﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3
#pragma IgorVersion = 8
#pragma hide=1

// list of math on stack operations
Function/S f_MaSOptions()

	string rstr
	rstr = "Average + Std Uncertainty;Derivative;Integral;"
	return rstr
end

// put the controls for math on stack
Function disp_tab24draw(variable pwidth, variable pheight, variable ptabpos)

	variable tvoffset, dtvoffset = 30
	variable tleft = 20
	
	tvoffset = ptabpos + 2*dtvoffset

	PopupMenu popupMaSHow_tab24,pos={tleft,tvoffset},size={125,25},title="Operation"
	PopupMenu popupMaSHow_tab24,mode=1,value=#"f_MaSOptions()",disable=1,proc=X_PopMenuProc
	PopupMenu popupMaSHow_tab24, help={"Set the operation to perform on the stack."}

	tvoffset += 2.4*dtvoffset

	PopupMenu popupMaSNegs_tab24,pos={tleft+150,tvoffset},size={100,25},title="Handle (-)?"
	PopupMenu popupMaSNegs_tab24,mode=1,value="Offset Lowest to Zero;Allow;Zero Out;",disable=1
	PopupMenu popupMaSNegs_tab24,help={"How should the math operations handle negative values?"}

	tvoffset += 1.2*dtvoffset
	
	Button buttonDoMaS_tab24,pos={pwidth-85,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Apply", disable=1

	return 0
end

// update tab 24
Function disp_updateTab24()

	STRUCT S_MaSSettings mas

	if (!f_IsStack())
		return -1
	endif
	
	PopupMenu popupMaSHow_tab24, win=$k_fullPanel, disable=0
	Sf_GetMaSSettings(mas)
	PopupMenu popupMaSNegs_tab24, win=$k_fullPanel, disable=((mas.how == 2 ? 0 : 2))
	
	return 0
end

// do math on stack
Function T2_DoMaS()

	string wdf = f_wdfstr(0)
	string imgname = f_DisplayImageID(2)
	wave/SDFR=$wdf imgsrc = $imgname

	STRUCT S_MasSettings mas
	Sf_GetMaSSettings(mas)
	
	SetDataFolder $wdf

	switch(mas.how)
		case 1:	// average + std uncertainty
		case 2:	// derivative
		case 3:	// integral
			T2_DoStackOP(imgsrc, imgname, mas.hnegs, mas.how)
			break
	endswitch
	
	SetDataFolder root:
	
	return 0
end

Static Function T2_DoStackOP(wave imgsrc, string imgwname, variable doneg, variable how)

	variable nlayers = DimSize(imgsrc,2)
	variable ic, imin
	
	string opname
	
	switch(how)
		case 1:		// ave + stu
			MatrixOP/FREE tmpimg = fp64(imgsrc)
			ImageTransform averageImage tmpimg
			wave M_aveImage, M_stdvImage
			opname = imgwname + "_ave"
			duplicate/O M_aveImage $opname
			opname = imgwname + "_std"
			duplicate/O M_stdvImage $opname
			killwaves/Z M_aveImage, M_stdvImage
			break
		case 2:		// derivative
			opname = imgwname + "_der"
			duplicate/O imgsrc $opname
			wave imgop = $opname
			Redimension/D imgop
			imgop[][][1,nlayers-1] = imgsrc[p][q][r] - imgsrc[p][q][r-1]
			switch(doneg)
				case 1:		// offset to zero
					imin = wavemin($imgwname)
					if (imin < 0)
						imgop += abs(imin)
					endif
					break
				case 2:		// allow
					break
				case 3:		// zero out
					imgop = imgop < 0 ? 0 : imgop
					break
			endswitch
			break
		case 3:		// integral
			opname = imgwname + "_int"
			duplicate/O imgsrc $opname
			wave imgop = $opname
			Redimension/D imgop
			for (ic=1;ic<nlayers;ic+=1)
				imgop[][][ic] += imgop[p][q][ic-1]
			endfor
			imgop[][][0,nlayers-1] /= r+1
			break
	endswitch
	
	SetDataFolder root:
	return 0
end

// list of split math operations
Function/S f_SpMaOptions()

	string rstr
	if (f_isSplit())
		rstr = "Add (+);Subtract (-);Multiply (x);Divide (/);Equation;"
	else
		rstr =  "\\M1(Add (+);\\M1(Subtract (-);\\M1(Multiply (x);\\M1(Divide (/);\\M1(Equation;"	
	endif
	return rstr
end

// put the controls for split math
Function disp_tab25draw(variable pwidth, variable pheight, variable ptabpos)

	variable tvoffset, dtvoffset = 30
	variable tleft = 20
	
	tvoffset = ptabpos + 2*dtvoffset

	PopupMenu popupSpMaHow_tab25,pos={tleft,tvoffset},size={125,25},title="Left (?) Right"
	PopupMenu popupSpMaHow_tab25,mode=1,value=#"f_SpMaOptions()",disable=1,proc=X_PopMenuProc
	PopupMenu popupSpMaHow_tab25, help={"Set the operation to perform on the split view."}

	PopupMenu popupSpMaOnPlane_tab25,pos={pwidth-215,tvoffset},size={100,23},title="on layer(s)", proc=X_PopMenuProc
	PopupMenu popupSpMaOnPlane_tab25,mode=1,value="Displayed Only;All Left,  This Right;\\M1(Each to Each;",disable=1
	PopupMenu popupSpMaOnPlane_tab25, help={"Only on displayed.\rUse Right as base on all Left layers.\rDo each Left to each Right."}
	tvoffset += dtvoffset
	
	SetVariable setvarSpMaEQN_tab25, pos={tleft,tvoffset},size={300,25},value=_STR:"",disable=1
	SetVariable setvarSpMaEQN_tab25, help={"Enter equation using L - left and R - right."}

	tvoffset += 1.4*dtvoffset

	PopupMenu popupSpMaNegs_tab25,pos={tleft+150,tvoffset},size={100,25},title="Handle (-)?"
	PopupMenu popupSpMaNegs_tab25,mode=1,value="Offset Lowest to Zero;Allow;Zero Out;",disable=1
	PopupMenu popupSpMaNegs_tab25,help={"How should the math operations handle negative values?"}

	tvoffset += dtvoffset
	
	Button buttonDoSpMa_tab25,pos={pwidth-85,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Apply", disable=1

	return 0
end

// update tab 25
Function disp_updateTab25()

	variable npl, npr
	string limg, rimg
		
	if (!f_IsSplit())
		return -1
	endif

	PopupMenu popupSpMaOnPlane_tab25, win=$k_fullPanel, disable=2, value="Displayed Only;All Left,  This Right;\\M1(Each to Each;"
	if (f_IsStack())
		limg = f_DisplayImageID(3)
		rimg = f_DisplayImageID(4)
		wave ileft = $limg
		wave iright = $rimg
		npl = DimSize(ileft,2)
		npr = DimSize(iright,2)
		if (npl != npr)
			PopupMenu popupSpMaOnPlane_tab25, win=$k_fullPanel, disable=0, mode=1
		else
			PopupMenu popupSpMaOnPlane_tab25, win=$k_fullPanel, disable=0, value="Displayed Only;All Left, This Right;Each to Each;"
		endif
	endif
	ControlInfo/W=$k_fullPanel popupSpMaHow_tab25
	SetVariable setvarSpMaEQN_tab25, win=$k_fullPanel, disable=(v_value<5)
	
	return 0
end

// button call for split math
Function T2_DoSplitMath()

	string swdf = f_wdfstr(0)
	string slimg = f_DisplayImageID(2)
	string srimg = f_DisplayImageID(5)
	string mlist = "a;s;m;d;e;"
	string strop
	
	DFREF wdf = $swdf
	wave/SDFR=wdf srclimg = $slimg
	wave/SDFR=wdf srcrimg = $srimg

	variable how, onplane, donegs, cPlane, ic, nPlanes
	string streqn, nname
	
	ControlInfo/W=$k_fullpanel popupSpMaHow_tab25
	how = v_value
	ControlInfo/W=$k_fullpanel popupSpMaOnPlane_tab25
	onplane = v_value
	ControlInfo/W=$k_fullpanel popupSpMaNegs_tab25
	donegs = v_value
	ControlInfo/W=$k_fullpanel setvarSpMaEQN_tab25
	streqn = s_value

	SetDataFolder wdf

	if (f_IsStack())
		cPlane = f_PlaneNumber()	
		switch(onplane)
			case 1:		// this one
				ImageTransform/P=(cPlane) getPlane srclimg
				wave M_ImagePlane
				duplicate/O M_ImagePlane tlimg
				wave tlimg
				Redimension/D tlimg
				if (DimSize(srcrimg,2) == 0)
					duplicate/O srcrimg M_ImagePlane
				else
					ImageTransform/P=(cPlane) getPlane srcrimg
				endif
				wave tming = do_SplitMathFunction(tlimg, M_ImagePlane, how, donegs, streqn)
				break
			case 2:		// right on each plane
				duplicate/O srclimg tlimg
				Redimension/D tlimg
				if (DimSize(srcrimg,2) == 0)
					duplicate/O srcrimg trimg
				else
					ImageTransform/P=(cPlane) getPlane srcrimg
					wave M_ImagePlane
					duplicate/O M_ImagePlane trimg
				endif
				nPlanes = DimSize(srclimg,2)
				for (ic=0;ic<nPlanes;ic+=1)
					ImageTransform/P=(ic) getPlane srclimg
					wave M_ImagePlane
					Redimension/D M_ImagePlane
					wave tming = do_SplitMathFunction(M_ImagePlane, trimg, how, donegs, streqn)
					tlimg[][][ic] = tming[p][q]
				endfor
				duplicate/O tlimg dwave
				break
			case 3:		// each to each
				duplicate/O srclimg tlimg
				redimension/D tlimg
				wave tming = do_SplitMathFunction(tlimg, srcrimg, how, donegs, streqn)
				break
		endswitch
	else
		duplicate/O srclimg tlimg
		redimension/D tlimg
		wave tming = do_SplitMathFunction(tlimg, srcrimg, how, donegs, streqn)
	endif
	
	strop = StringFromList(how-1,mlist)
	nname = slimg + "_sm" + strop
	if (how > 4)
		strop = streqn
	endif
	sprintf strop, "%s: %s %s", strop, slimg, srimg
	wave/Z dimg = $nname
	if (waveexists(dimg))
		if (!f_IsStack())
			duplicate/O tming $nname
			Note/K $nname, strop
		else
			switch(onplane)
				case 1:
					dimg[][][cPlane] = tming[p][q]
					strop += " on plane " + num2str(cPlane)
					Note $nname, strop
					break
				case 2:
				case 3:
					duplicate/O tming dimg
					Note/K $nname, strop
					break
			endswitch
		endif
	else
		duplicate/O tming $nname
		Note $nname, strop
	endif

	killwaves/Z M_ImagePlane, tlimg, trimg, tming
	SetDataFolder root:
	
	return 0
end

// do the split math
Function/WAVE do_SplitMathFunction(wave limg, wave rimg, variable how, variable donegs, string streqn)
	
	duplicate/O limg dwave
	redimension/D dwave
	switch(how)
		case 1:	// add
			dwave = limg + rimg
			break
		case 2:	// subtract
			dwave = limg - rimg
			break
		case 3:	// multiply
			dwave = limg*rimg
			break
		case 4:	// divide
			dwave = limg/rimg
			break
		case 5:	// equation
			do_strsplitmath(limg, rimg, streqn)
			break
	endswitch
	
	switch(donegs)
		case 1:		// offset to minimum
			WaveStats/Q dwave
			if (V_min < 0)
				dwave += abs(V_min)
			endif
			break
		case 2:		// allow
			break
		case 3:		// set to zero
			dwave = dwave < 0 ? 0 : dwave
			break
	endswitch
	
	return dwave
end

Static Function do_strsplitmath(wave limg, wave rimg, string streqn)

	string theCmd, nl, nr
	
	wave dwave
	nl = NameOfWave(limg)
	nr = NameOfWave(rimg)
	theCmd = ReplaceString("L",streqn,"L::")
	theCmd = ReplaceString("R",theCmd,"R::")
	theCmd = ReplaceString("L::",theCmd,nl)
	theCmd = ReplaceString("R::",theCmd,nr)
	theCmd = "dwave = " + theCmd
	Execute theCmd
	return 0
end